<?php

use yii\helpers\Url;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use kartik\grid\GridView;
use johnitvn\ajaxcrud\CrudAsset; 
use johnitvn\ajaxcrud\BulkButtonWidget;
use yii\bootstrap\Tabs;
use common\models\User;

/* @var $this yii\web\View */
/* @var $searchModel frontend\models\BotsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
CrudAsset::register($this);

$r = explode('/',Yii::$app->request->url);

if(isset(Yii::$app->user->identity->groups)){
    $groups = json_decode(Yii::$app->user->identity->groups);
}

$items = [];
$resetLink = '';

foreach ($groups as $key => $value) {
    if(isset($r[2])){
        $resetLink = ($value == explode('?', $r[2])[0]) ? '/botsdata/'.$value : '';
        array_push($items, [
            'label' => $value,
            'active' => ($value == explode('?', $r[2])[0]) ? true : false,
            'url' => ''.$value,
        ]);
    }
}

$autorefresh = User::getUserSettingValue('autorefresh');
    
if($autorefresh===false){
    User::setUserSettingValue('autorefresh',30);
}
$autorefresh = User::getUserSettingValue('autorefresh');

//$this->params['breadcrumbs'][] = $this->title;
$ar = ($autorefresh===false) ? 30 : $autorefresh;

$this->registerJs('interval = '.$ar, \yii\web\VIEW::POS_HEAD);

$this->registerJs('

var s = setInterval(refresh,interval*1000)

function autorefreshChanged(){
    var e = document.getElementById("autorefresh")
    interval = e.options[e.selectedIndex].value

    $.ajax({
        url:"/botsdata/autorefreshchanged?a="+interval,  
        success:function(data) {
            interval = data
            clearInterval(s)
            s = setInterval(refresh,interval*1000)
        }
    })
}

function viewmodeChanged(){
    var e = document.getElementById("viewbots")
    b = e.checked
    var e = document.getElementById("viewhoney")
    h = e.checked
    var e = document.getElementById("viewtest")
    t = e.checked

    var resv = ""
    if(b===true){
        resv += "1"
    }else{
        resv += "0"
    }
    if(h===true){
        resv += "1"
    }else{
        resv += "0"
    }
    if(t===true){
        resv += "1"
    }else{
        resv += "0"
    }   

    $.ajax({
        url:"/botsdata/viewmodechanged?a="+resv,  
        success:function(data) {
            window.location.reload()
        }
    })
}

function refresh(){

    if(interval > 0){
        $.pjax.reload({
        container:"#crud-datatable-pjax",
        
        })
    }
}', \yii\web\VIEW::POS_HEAD);

$v = User::getUserSettingValue('viewmode');
if($v===false){
    User::setUserSettingValue('viewmode','100');
    $viewmode = str_split('100');
}else{
    $viewmode = $v;
}

?>

<div class="container-fluid bots-container">

    <?= Tabs::widget([
        'items' => $items,
    ]); ?>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
<div id="ajaxCrudDatatable">
        <?=GridView::widget([
            'moduleId' => 'gridviewKrajee',
            'id'=>'crud-datatable',
            'dataProvider' => $dataProvider,
            'filterModel' => $searchModel,
            'tableOptions' => ['class' => 'special_table table-striped table-bordered table-sm'],
            'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ' '],
            'containerOptions' => ['style' => 'overflow: auto'], // only set when $responsive = false
            'headerRowOptions' => ['class' => 'kartik-sheet-style'],
            'filterRowOptions' => ['class' => 'kartik-sheet-style'],
            'options' => [ 'style' => 'table-layout:fixed;' ],
            'pjax'=>true,
            /*'pjaxSettings'=>[
                'neverTimeout'=>true,
                'beforeGrid'=>'My fancy content before.',
                'afterGrid'=>'My fancy content after.',
            ],*/
            'resizableColumns'=>true,
            'columns' => require(__DIR__.'/_columns.php'),
            'toolbar'=> [
                ['content'=>
                    Html::a('<i class="glyphicon glyphicon-repeat"></i>', $resetLink,
                    ['data-pjax'=>1, 'class'=>'btn btn-default', 'title'=>'Reset Grid']).
                    '{toggleData}'.
                    '{export}'
                ],
            ],
            'rowOptions' => function ($model) {
                if ($model->status == 2) {
                        return ['class' => 'color-dead'];
                    } elseif ($model->status == 1) {
                        return ['class' => 'color-online'];
                    } elseif ($model->status == 0) {
                        return ['class' => 'color-offline'];
                    }
                if($model->busy == 1){
                    return ['class' => 'color-busy'];
                }
            },          
            'striped' => true,
            'condensed' => true,
            'responsive' => true,          
            'panel' => [
                'type' => 'primary', 
                'heading' => '<i class="glyphicon glyphicon-list"></i> &nbsp;&nbsp;Group <b>'.explode('?', $r[2])[0].'</b> Bots listing',
                'before'=>
                Html::checkbox('show_bots', ($viewmode[0]==1) ? true: false, ['label' => 'Show bots', 'style' => ['color' => '#FF5733', 'margin-left' => '10px'], 'id' => 'viewbots', 'onchange' => 'viewmodeChanged("100")']).
                Html::checkbox('show_honeypots', ($viewmode[1]==1) ? true: false, ['label' => 'Show honeypots', 'style' => ['color' => '#FF5733', 'margin-left' => '10px'], 'id' => 'viewhoney', 'onchange' => 'viewmodeChanged("010")']).
                Html::checkbox('show_tests', ($viewmode[2]==1) ? true: false, ['label' => 'Show testbots', 'style' => ['color' => '#FF5733', 'margin-left' => '10px'], 'id' => 'viewtest', 'onchange' => 'viewmodeChanged("001")']).
                '&nbsp;&nbsp;&nbsp;<label><b>Autorefresh&nbsp;</b></label>'.Html::dropDownList('autorefresh', $autorefresh, ['0'=>'off','30'=>'30 sec.' ,'60'=>'1 min.', '180'=>'3 min.', '300'=>'5 min.', '600'=>'10 min.'], ['style' => ['color' => '#FF5733', 'width' => '80px'], 'id' => 'autorefresh', 'onchange' => 'autorefreshChanged()'])
                ,
                'after'=>'<div class="clearfix"></div>',
            ]
        ])?>
    </div>
</div>
<?php Modal::begin([
    "id"=>"ajaxCrudModal",
    "footer"=>"",// always need it for jquery plugin
])?>
<?php Modal::end(); ?>
